# Codex Memory Kit v2.3 — Agent Control Plane
> File: `.codex/agents.md`

You are **Codex** operating inside this repository. Your job is to complete tasks while using local, versioned context stored under `.codex/`.

This file is the **control plane**: boot behavior, memory usage, skill triggers, mutation guards, command handling, and a visible **UI indicator**.

---

## 0) Commands (Always Available)

### 0.1) start  (BOOTSTRAP)
When the user says **"start"**, enter **BOOTSTRAP mode**.

If `.codex/meta/project-mode.md` does NOT exist, you MUST:
1. Create the scaffold in Section 2 (so the files exist).
2. Ask the user to choose a mode by replying with one of:
   - `design-first`
   - `existing`
   - `memory-only`
3. Write the chosen mode to `.codex/meta/project-mode.md` (set `Current:`).
4. Append a mode-selection entry in `.codex/state/history.md` under **Mode Changes**.
5. Stop (do not continue bootstrapping until mode is set).

If `.codex/meta/project-mode.md` exists, continue bootstrapping:
1. Ensure the scaffold in Section 2 exists (create missing folders/files).
2. Read `.codex/brief.md` and initialize memory files (Section 3).
3. Discover installed skills (Section 4) and generate `.codex/memory/capabilities.md`.
4. Apply mode rules (Section 5).
5. Write a boot record to `.codex/state/history.md` under **Entries**.
6. Create/update `.codex/meta/initialized.flag` with the current date/time.
7. Exit BOOTSTRAP and wait for the next user task.

### 0.2) switch-mode: <design-first|existing|memory-only>
If the user message matches:
`switch-mode: <design-first|existing|memory-only>`

Then:
1. Read current mode from `.codex/meta/project-mode.md` (if any).
2. Validate the requested mode is one of: design-first, existing, memory-only.
3. Update `.codex/meta/project-mode.md` to set `Current:` to the requested mode.
4. Append an audit entry to `.codex/state/history.md` under **Mode Changes**:
   - date/time
   - old mode → new mode
   - reason: “user command”
5. Do NOT re-run BOOTSTRAP automatically unless the user also asks to `start`.

### 0.3) refresh-skills
Forces a rescan of skills and regenerates `.codex/memory/capabilities.md`.
Append an entry to `.codex/state/history.md` under **Skill Refreshes**.

### 0.4) memory-doctor
Runs invariant checks and writes a short report to `.codex/state/doctor-report.md`.
Append a summary line to `.codex/state/history.md` under **Diagnostics**.

### 0.5) approve-ui: <note>
Design-first shortcut to unlock backend work cleanly.
Writes `.codex/meta/ui-approved.flag` + appends a decision entry.

### 0.6) Memory scope locks (v2.3)

#### lock: memory/<file>.md
Adds a file lock in `.codex/meta/memory-locks.md`.

#### lock-section: memory/<file>.md :: <Heading Text>
Adds a section lock in `.codex/meta/memory-locks.md`.

#### unlock: memory/<file>.md
Removes a file lock.

#### unlock-section: memory/<file>.md :: <Heading Text>
Removes a section lock.

#### unlock-all
Clears all locks (sets Active locks back to “(none)”).

Lock/unlock behavior:
- Always validate the target exists under `.codex/memory/` (for file locks).
- Always append an audit entry to `.codex/state/history.md` under **Lock Changes**.
- Never silently fail; confirm what changed.

---

## 1) NORMAL Mode (Every Task)

### 1.1) UI Indicator (Every Response)

You MUST display a status indicator as the first line of every response:

- If running BOOTSTRAP after the user said "start":
  - `[Codex Memory: Bootstrapping | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a> | Locks: <ON (N)|OFF (0)>]`
- Else if `.codex/meta/initialized.flag` exists AND required memory files are readable:
  - `[Codex Memory: Active | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a> | Locks: <ON (N)|OFF (0)>]`
- Else:
  - `[Codex Memory: Inactive | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a> | Locks: <ON (N)|OFF (0)>]`

UI field rules:
- If mode != `design-first`: UI = `n/a`
- If mode == `design-first`:
  - UI = `approved` if `.codex/meta/ui-approved.flag` exists
  - else UI = `not-approved`

Locks field rules:
- Parse `.codex/meta/memory-locks.md` Active locks list.
- N = number of `FILE:` + `SECTION:` lines (excluding “(none)”).
- If `.codex/meta/memory-locks.md` missing, treat as 0.

Other rules:
- The indicator must be the first text in the response (first line).
- Do not wrap it in markdown code fences.

### Always read (in this order)
1. `.codex/meta/project-mode.md`
2. `.codex/meta/design-workflow.md`
3. `.codex/brief.md`
4. `.codex/meta/mutation-guards.md`
5. `.codex/meta/memory-locks.md`
6. `.codex/meta/skill-trigger-spec.md`
7. `.codex/memory/*` (including `capabilities.md`)
8. `.codex/state/active-task.md` (if present)
9. `.codex/state/doctor-report.md` (if present; read-only)

### Always write (end of task)
1. Update `.codex/state/active-task.md` (short: intent → actions → results → next)
2. Append a summary entry to `.codex/state/history.md` under **Entries**
3. Update memory ONLY when allowed by:
   - `.codex/meta/mutation-guards.md`
   - and locks in `.codex/meta/memory-locks.md`

---

## 2) Required Scaffold (Create if Missing)

.codex/
  agents.md
  brief.md
  README.md
  QUICKSTART.md
  CHANGELOG.md
  LICENSE

.codex/memory/
  project.md
  architecture.md
  constraints.md
  decisions.md
  patterns.md
  glossary.md
  capabilities.md

.codex/state/
  active-task.md
  history.md
  doctor-report.md

.codex/meta/
  initialized.flag
  ui-approved.flag
  project-mode.md
  mutation-guards.md
  memory-locks.md
  skill-trigger-spec.md
  design-workflow.md
  tools.md

.codex/scripts/
  refresh-skills.sh
  memory-doctor.sh

---

## 3) Locks enforcement (non-negotiable)

Before editing any `.codex/memory/<file>.md`:
1) Check `.codex/meta/memory-locks.md`.
2) If `FILE: memory/<file>.md` exists → do not edit.
3) If attempting to edit a section under a heading, and
   `SECTION: memory/<file>.md :: <Heading Text>` exists → do not edit.

If blocked:
- Explain which lock blocked it.
- Provide the exact `unlock...` command.
- Suggest running `memory-doctor` if confusion persists.

END
