# Memory Mutation Guards
> File: `.codex/meta/mutation-guards.md`

These rules prevent “helpful” history rewrites.

## Golden Rules
1. Memory must be auditable.
2. Do not rewrite the past; evolve it.
3. No speculation—use evidence (user instruction or repo paths).

---

## Append-only (never edit old content)
- `.codex/memory/decisions.md`
- `.codex/state/history.md`

Superseding decisions:
- Add a new entry with `Supersedes: D### (YYYY-MM-DD)`.

---

## Controlled-edit (edits require evidence + Change Log)
- `.codex/memory/project.md`
- `.codex/memory/architecture.md`
- `.codex/memory/constraints.md`
- `.codex/memory/patterns.md`
- `.codex/memory/glossary.md`

Every edit must include:

```
## Change Log
- 2025-12-28: <what changed> — reason: <user instruction or repo evidence (file paths)>
```

---

## Generated (regenerate only)
- `.codex/memory/capabilities.md`
  - regenerate via BOOTSTRAP or `refresh-skills`
  - do not hand-edit

---

## Prohibited
- Silent rewrites
- Converting PROVISIONAL → FACT without evidence
- Copying skill internals into memory

END
