# Codex Memory Kit v2.2 — Agent Control Plane
> File: `.codex/agents.md`

You are **Codex** operating inside this repository. Your job is to complete tasks while using local, versioned context stored under `.codex/`.

This file is the **control plane**: boot behavior, memory usage, skill triggers, mutation guards, command handling, and a visible **UI indicator**.

---

## 0) Commands (Always Available)

### 0.1) start  (BOOTSTRAP)
When the user says **"start"**, enter **BOOTSTRAP mode**.

If `.codex/meta/project-mode.md` does NOT exist, you MUST:
1. Create the scaffold in Section 2 (so the files exist).
2. Ask the user to choose a mode by replying with one of:
   - `design-first`
   - `existing`
   - `memory-only`
3. Write the chosen mode to `.codex/meta/project-mode.md` (set `Current:`).
4. Append a mode-selection entry in `.codex/state/history.md` under **Mode Changes**.
5. Stop (do not continue bootstrapping until mode is set).

If `.codex/meta/project-mode.md` exists, continue bootstrapping:
1. Ensure the scaffold in Section 2 exists (create missing folders/files).
2. Read `.codex/brief.md` and initialize memory files (Section 3).
3. Discover installed skills (Section 4) and generate `.codex/memory/capabilities.md`.
4. Apply mode rules (Section 5).
5. Write a boot record to `.codex/state/history.md` under **Entries**.
6. Create/update `.codex/meta/initialized.flag` with the current date/time.
7. Exit BOOTSTRAP and wait for the next user task.

### 0.2) switch-mode: <design-first|existing|memory-only>
If the user message matches:

`switch-mode: <design-first|existing|memory-only>`

Then:
1. Read current mode from `.codex/meta/project-mode.md` (if any).
2. Validate the requested mode is one of: design-first, existing, memory-only.
3. Update `.codex/meta/project-mode.md` to set `Current:` to the requested mode.
4. Append an audit entry to `.codex/state/history.md` under **Mode Changes**:
   - include date/time
   - include old mode → new mode
   - include reason: “user command”
5. Do NOT re-run BOOTSTRAP automatically unless the user also asks to `start`.

### 0.3) refresh-skills
Forces a rescan of skills and regenerates `.codex/memory/capabilities.md`.

Behavior:
1. Scan `~/.codex/skills/` and `.codex/skills/` (if present).
2. Regenerate `.codex/memory/capabilities.md` as a catalog.
3. Append an entry to `.codex/state/history.md` under **Skill Refreshes** (date/time + counts + changes if detectable).

### 0.4) memory-doctor
Runs invariant checks and writes a short report.

Behavior:
1. Validate required scaffold exists (Section 2).
2. Validate mode is one of allowed values.
3. Validate append-only files exist:
   - `.codex/memory/decisions.md`
   - `.codex/state/history.md`
4. Validate that `.codex/memory/capabilities.md` looks generated (must contain “Generated” header).
5. Validate UI gate status:
   - If mode is `design-first`, ensure `.codex/meta/ui-approved.flag` exists before backend work is attempted.
6. Write report to `.codex/state/doctor-report.md`.
7. Append a summary line to `.codex/state/history.md` under **Diagnostics**.

### 0.5) approve-ui: <note>
Design-first shortcut to unlock backend work cleanly.

Behavior:
1. Only valid in mode `design-first`.
2. Append to `.codex/memory/decisions.md`:
   - “UI Approved” + date/time + note + scope (pages/components if known).
3. Create/update `.codex/meta/ui-approved.flag` with date/time + note.
4. Append an entry to `.codex/state/history.md` under **Entries**.

---

## 1) NORMAL Mode (Every Task)

### 1.1) UI Indicator (Every Response)

You MUST display a status indicator as the first line of every response:

- If running BOOTSTRAP after the user said "start":
  - `[Codex Memory: Bootstrapping | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a>]`
- Else if `.codex/meta/initialized.flag` exists AND required memory files are readable:
  - `[Codex Memory: Active | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a>]`
- Else:
  - `[Codex Memory: Inactive | Mode: <mode-or-unset> | UI: <approved|not-approved|n/a>]`

UI field rules:
- If mode != `design-first`: UI = `n/a`
- If mode == `design-first`:
  - UI = `approved` if `.codex/meta/ui-approved.flag` exists
  - else UI = `not-approved`

Other rules:
- The indicator must be the first text in the response (first line).
- Do not wrap it in markdown code fences.
- Use the current mode from `.codex/meta/project-mode.md` if present; otherwise use `unset`.

### Always read (in this order)
1. `.codex/meta/project-mode.md`
2. `.codex/meta/design-workflow.md`
3. `.codex/brief.md`
4. `.codex/meta/mutation-guards.md`
5. `.codex/meta/skill-trigger-spec.md`
6. `.codex/memory/*` (including `capabilities.md`)
7. `.codex/state/active-task.md` (if present)
8. `.codex/state/doctor-report.md` (if present; read-only)

### Always write (end of task)
1. Update `.codex/state/active-task.md` (short: intent → actions → results → next)
2. Append a summary entry to `.codex/state/history.md` under **Entries**
3. Update memory ONLY when allowed by `meta/mutation-guards.md`

---

## 2) Required Scaffold (Create if Missing)

.codex/
  agents.md
  brief.md
  README.md
  QUICKSTART.md
  CHANGELOG.md
  LICENSE

.codex/memory/
  project.md
  architecture.md
  constraints.md
  decisions.md
  patterns.md
  glossary.md
  capabilities.md   (generated; do not hand-edit)

.codex/state/
  active-task.md
  history.md
  doctor-report.md

.codex/meta/
  initialized.flag
  ui-approved.flag
  project-mode.md
  mutation-guards.md
  skill-trigger-spec.md
  design-workflow.md
  tools.md

.codex/scripts/
  refresh-skills.sh
  memory-doctor.sh

Notes:
- `capabilities.md` is generated from skill discovery; regenerate instead of editing.
- `decisions.md`, `history.md` are append-only (see guards).

---

## 3) Memory Initialization from brief.md (BOOTSTRAP)
Read `.codex/brief.md` and generate:
- `.codex/memory/project.md`
- `.codex/memory/architecture.md`
- `.codex/memory/constraints.md`
- `.codex/memory/patterns.md`
- `.codex/memory/decisions.md`
- `.codex/memory/glossary.md`

Rules:
- If unknown, mark as **TBD**. Do not invent.
- Inferred patterns MUST be **PROVISIONAL** + cite evidence (file paths).

---

## 4) Skill Discovery → capabilities.md (BOOTSTRAP + refresh-skills)
Scan both:
1. Global installed skills: `~/.codex/skills/` (example: `/Users/user/.codex/skills`)
2. Repo-local skills (optional): `.codex/skills/`

Generate `.codex/memory/capabilities.md` as a catalog of:
- name, purpose (1 line), triggers, typical inputs/outputs

Do not copy skill internals into memory.

---

## 5) Mode Rules (Phase Gates)

Mode is stored in `.codex/meta/project-mode.md`.

- `design-first`: NEW project. Default gate: front-end prototype first (HTML-only) + motion-first design.
  - Backend work blocked until `.codex/meta/ui-approved.flag` exists or an “UI Approved” decision exists.
- `existing`: Existing repo. Ask user if they want a design review before significant UI changes.
- `memory-only`: Skip design gates. Use memory bank for consistency/coordination only.

Detailed behavior is defined in `.codex/meta/design-workflow.md` and must be followed.

---

## 6) Skill Trigger Heuristics (Deterministic Selection)
Use `.codex/meta/skill-trigger-spec.md`.

If multiple skills match:
1. Most specific trigger match
2. Closest output type
3. Lower-risk first (analysis/design before write-heavy)

Log invoked skills in `.codex/state/active-task.md`.

---

## 7) Memory Mutation Guards
All mutation rules are in `.codex/meta/mutation-guards.md`. Obey strictly.

---

## 8) Tools / MCP / Background Terminals
Document stable tool contracts in `.codex/meta/tools.md`.

---

END
