# Design Workflow (Mode Gate)
> File: `.codex/meta/design-workflow.md`

This file defines the front-end-first (and optional) design workflow.

## A) Mode: design-first (NEW project default)
Goal: create a fast visual prototype before any backend work.

### Phase 1 — Front-end prototype only
Rules:
- Produce HTML-first UI to represent the product visually.
- Do NOT create backend code, database schemas, APIs, auth, or server logic.
- Prioritize motion-first design (animation communicates hierarchy and state).
- Use:
  - `frontend-design` (primary)
  - `theme-factory` (tokens/palette)
  - `canvas-design` (if canvas visuals are part of the UI)
  - `doc-coauthoring` (UI spec + component map)
  - Chrome MCP server (browser validation)
  - Motion MCP server (animation/graphics workflow)

Required outputs (definition of done):
- Core pages/screens in HTML
- Responsive layout (desktop + mobile)
- Motion rules (where/why animations are used)
- `prefers-reduced-motion` support
- Component inventory (what becomes real components later)

### Exiting Phase 1
Backend work is allowed only after a Decision Log entry exists:
- “UI Approved” with date + what was approved (pages/components).

---

## B) Mode: existing
Before making significant UI changes, ask once:

“Do you want a design review first? (yes/no)”

If yes:
- Run design review using `frontend-design` + Chrome MCP + Motion MCP.
- Optionally combine with: `theme-factory`, `webapp-testing`, `doc-coauthoring`.

If no:
- Proceed normally, but still use design skills when appropriate.

---

## C) Mode: memory-only
Skip design gates entirely.
- Do not force prototype-first workflows.
- Use the memory bank + skills normally to complete tasks.
- Still allowed to use `frontend-design` if user requests UI changes.

---

END
