# Codex Memory Kit v2.1.1 — Modes + Mode Switching + Mode UI Indicator + Mode Change Log

This kit gives Codex a repo-local “memory bank” under `.codex/`, with:
- A control plane (`.codex/agents.md`)
- A project brief (`.codex/brief.md`)
- Structured memory (`.codex/memory/`)
- Deterministic skill triggers
- Mutation guards (no rewriting history)
- A visible UI indicator including mode
- A project mode prompt on first `start`
- A mode switching command you can use anytime
- A dedicated **Mode Changes** section in `state/history.md`

Modes:
- `design-first` (new project, motion-first HTML prototype gate)
- `existing` (ask for design review)
- `memory-only` (skip design gates)

---

## Install
1. Copy the `.codex/` folder into the root of your repo.
2. Commit (recommended):
   ```bash
   git add .codex && git commit -m "Add Codex Memory Kit v2.1.1"
   ```

---

## First run
1. Edit `.codex/brief.md`.
2. In Codex, type: `start`

If mode isn’t set yet, Codex will ask you to choose one:
- `design-first`
- `existing`
- `memory-only`

Reply with one word. Codex stores it in `.codex/meta/project-mode.md` and logs it in `.codex/state/history.md` under **Mode Changes**.

---

## Switching modes anytime

Send this command:

`switch-mode: design-first`
`switch-mode: existing`
`switch-mode: memory-only`

Codex will:
- update `.codex/meta/project-mode.md`
- append an audit entry to `.codex/state/history.md` under **Mode Changes**

No re-bootstrap happens unless you also run `start`.

---

## UI status indicator (includes mode)
Codex should prefix every response with:
- `[Codex Memory: Bootstrapping | Mode: <mode>]`
- `[Codex Memory: Active | Mode: <mode>]`
- `[Codex Memory: Inactive | Mode: <mode>]`

---

## License
Choose a license (MIT/Apache/proprietary). Unlicensed by default.

END
