# Memory Mutation Guards
> File: `.codex/meta/mutation-guards.md`

These rules prevent Codex from “helpfully” rewriting history.

## Golden Rules
1. **Memory must be auditable.** If something changes, record the change and why.
2. **Do not silently rewrite the past.** Evolve it with append-only logs or explicit change notes.
3. **No speculation.** If not supported by user instruction or repo evidence, mark as **PROVISIONAL** or **TBD**.

---

## File Classes

### A) Append-only (never edit old content)
- `.codex/memory/decisions.md`
- `.codex/state/history.md`

**Allowed changes:** append new entries only.

**Superseding a decision:** never delete. Add a new entry:
- `Supersedes: D### (YYYY-MM-DD)` and briefly explain why.

---

### B) Controlled-edit (edits allowed only with evidence)
- `.codex/memory/project.md`
- `.codex/memory/architecture.md`
- `.codex/memory/constraints.md`
- `.codex/memory/patterns.md`
- `.codex/memory/glossary.md`

**Edits allowed only when:**
- user explicitly changes requirements, OR
- repo evidence changes reality (new modules/stack/constraints)

**Every edit MUST include a Change Log entry** at the bottom:

```
## Change Log
- 2025-12-28: <what changed> — reason: <user instruction or repo evidence (file paths)>
```

---

### C) Generated (regenerate, don’t edit)
- `.codex/memory/capabilities.md`

Source of truth:
- `~/.codex/skills/`
- `.codex/skills/` (optional)

---

## Prohibited Mutations (Hard No)
- “Improving” older decision wording for clarity/style.
- Converting **PROVISIONAL** items into **FACT** without evidence.
- Retroactively changing architecture narratives without a Change Log entry.
- Copying large skill contents into memory.

---

## Provisional Marking
When something seems likely but unverified, label it:

- `PROVISIONAL:` <statement>
- Evidence: `<file paths or quoted user instruction>`

Only remove PROVISIONAL when you have strong evidence.

---

END
