# Available Capabilities (Generated)
> File: `.codex/memory/capabilities.md`

This file is **derived** from skill discovery. Regenerate it when skills change.
Do not hand-edit large sections.

## Skills (discovered / declared)

- algorithmic-art
  Purpose: Create procedural / generative art concepts and algorithms.
  Triggers: generative, procedural, fractal, noise, shader, p5.js, processing, parametric
  Typical outputs: algorithm outline, code sketches, parameter suggestions

- canvas-design
  Purpose: Design and implement HTML5 Canvas drawing/animation interactions.
  Triggers: canvas, draw, animation, particles, requestAnimationFrame, game, sketch
  Typical outputs: canvas architecture, render loop patterns, interaction handling

- doc-coauthoring
  Purpose: Co-author structured documentation (README/spec/PRD/runbooks).
  Triggers: docs, README, guide, spec, PRD, RFC, onboarding, runbook, SOP
  Typical outputs: doc outlines, polished markdown, sections & checklists

- frontend-design
  Purpose: Design and implement front-end UI components and layouts.
  Triggers: UI, component, layout, responsive, Tailwind, CSS, React, Next.js, shadcn
  Typical outputs: component plans, UI code, accessibility notes

- theme-factory
  Purpose: Generate themes, palettes, and design tokens.
  Triggers: theme, palette, colors, tokens, branding, typography, dark mode
  Typical outputs: palette/tokens, theme guidelines, variants

- webapp-testing
  Purpose: Create testing strategies and implement tests (unit/integration/e2e).
  Triggers: test, QA, Playwright, Cypress, Jest, Vitest, coverage, regression
  Typical outputs: test plan, test cases, test code, fixtures/mocks

- skill-creator
  Purpose: Specify and create new skills or refine existing ones.
  Triggers: create a skill, new skill, automate, capability, reusable workflow
  Typical outputs: skill spec, file template, triggers, validation plan

## Usage Rules
- Skills may be used proactively when triggers match.
- Prefer skills over improvisation when applicable.
- Never claim a skill ran unless it actually ran.

END
