# Codex Memory Kit — Agent Control Plane
> File: `.codex/agents.md`

You are **Codex** operating inside this repository. Your job is to complete tasks while using local, versioned context stored under `.codex/`.

This file is the **control plane**: it defines boot behavior, memory usage, skill triggers, and mutation guards.

---

## 0) Start Command (BOOTSTRAP)

When the user says **"start"**, enter **BOOTSTRAP mode**:

1. Ensure the scaffold in **Section 2** exists (create missing folders/files).
2. Read `.codex/brief.md` and initialize memory files (Section 3).
3. Discover installed skills (Section 4) and generate `.codex/memory/capabilities.md`.
4. Write a boot record to `.codex/state/history.md`.
5. Create/update `.codex/meta/initialized.flag` with the current date/time.
6. Exit BOOTSTRAP and wait for the next user task.

If `.codex/meta/initialized.flag` already exists, skip BOOTSTRAP and run **NORMAL mode**.

---

## 1) NORMAL Mode (Every Task)

### Always read (in this order)
1. `.codex/brief.md`
2. `.codex/meta/mutation-guards.md`
3. `.codex/meta/skill-trigger-spec.md`
4. `.codex/memory/*` (including `capabilities.md`)
5. `.codex/state/active-task.md` (if present)

### Always write (end of task)
1. Update `.codex/state/active-task.md` (short: intent → actions → results → next)
2. Append a summary entry to `.codex/state/history.md`
3. Update memory ONLY when allowed by `meta/mutation-guards.md`

---

## 2) Required Scaffold (Create if Missing)

Create these paths if they do not exist:

.codex/
  agents.md
  brief.md
  README.md

.codex/memory/
  project.md
  architecture.md
  constraints.md
  decisions.md
  patterns.md
  glossary.md
  capabilities.md   (generated; do not hand-edit)

.codex/state/
  active-task.md
  history.md

.codex/meta/
  initialized.flag
  mutation-guards.md
  skill-trigger-spec.md
  tools.md

Notes:
- `capabilities.md` is **generated** from skill discovery; regenerate instead of editing.
- `decisions.md` and `history.md` are **append-only** (see guards).

---

## 3) Memory Initialization from brief.md (BOOTSTRAP)

Read `.codex/brief.md` and generate:

### `.codex/memory/project.md`
- 1–2 paragraphs describing what the project **is**
- a clear “what this project is **NOT**”
- project goals + non-goals

### `.codex/memory/architecture.md`
- high-level system layout
- key modules/services
- important data flows (bullets)
- if unknown, mark sections as **TBD** (do not invent)

### `.codex/memory/constraints.md`
- stack constraints
- environment constraints
- must-not-break invariants
- security/performance constraints (if in brief)

### `.codex/memory/patterns.md`
- include patterns **explicitly** stated in brief, OR **evidenced** in repo (cite file paths)
- inferred patterns MUST be marked **PROVISIONAL** + cite evidence

### `.codex/memory/decisions.md`
- initialize a “Decision Log”
- include only decisions explicitly stated in brief
- never infer decisions during bootstrap

### `.codex/memory/glossary.md`
- list domain terms found in brief (short definitions)

---

## 4) Skill Discovery → capabilities.md (BOOTSTRAP + Whenever Skills Change)

### Skill locations (scan both)
1. **Global installed skills** (macOS default): `~/.codex/skills/`
2. **Repo-local skills** (optional): `.codex/skills/`

Record a catalog in `.codex/memory/capabilities.md` containing:
- skill name
- purpose (1 line)
- triggers (when to use)
- typical inputs/outputs (if documented)

### Parsing rules (priority)
1. If skill file begins with a YAML header block (`---`), use it.
2. Else use:
   - filename as skill name
   - first heading as purpose
   - first “Triggers” or “Use when” section if present
3. If still unclear, include the skill as **undocumented** and continue.

### Output rules
- `capabilities.md` must be compact and practical.
- Do not copy large skill contents into memory.
- Never claim a skill ran unless you actually invoked it.

---

## 5) Skill Trigger Heuristics (Deterministic Selection)

You may invoke matching skills **without user input** when useful.

A skill is a match if ANY are true:
- the task text contains one of the skill’s trigger keywords
- the task asks for the skill’s output type (e.g., “write docs”, “create tests”)
- the task fits a category mapped in `meta/skill-trigger-spec.md`

If multiple skills match:
1. Prefer the most specific match (closest trigger phrase)
2. Else prefer the skill with the closest output type
3. Else prefer “analysis-only” skills over “write-heavy” skills

When you invoke a skill, add to `.codex/state/active-task.md`:
- `Invoked skill: <name> — reason: <trigger/category>`

---

## 6) Memory Mutation Guards (No “Helpful History Rewrites”)

**All mutation rules are in** `.codex/meta/mutation-guards.md`.

Codex must obey them strictly.

---

## 7) Tools / MCP / Background Terminals

Document stable tool availability and usage rules in:
- `.codex/meta/tools.md`

Rules:
- Tool availability is environment state, not durable memory truth.
- Record *contracts and rules*, not ephemeral outputs.
- Summarize tool outcomes in `.codex/state/history.md`, not memory.

---

END
