# Codex Memory Kit (Local, Auditable “Memory” for Codex)

This kit gives Codex a **repo-local** memory system under `.codex/`:
- A project **brief** (`.codex/brief.md`) that acts like the source of truth
- A **control plane** (`.codex/agents.md`) that defines boot + rules
- A structured **memory bank** (`.codex/memory/`)
- Skill discovery + deterministic **skill triggers**
- **Mutation guards** so history can’t be rewritten “helpfully”

Everything is plain Markdown. Everything can be committed to git.

---

## What you get

Inside `.codex/`:
- `agents.md` — boot rules + task lifecycle
- `brief.md` — project description and plan seed
- `memory/` — durable context (architecture, constraints, decisions, patterns)
- `meta/` — mutation guards + trigger heuristics
- `state/` — active task + append-only history

Codex skills live globally at:
- `~/.codex/skills/` (macOS)

This kit **does not copy skill internals** into memory. It only catalogs what skills exist and when to use them.

---

## Install (macOS, VS Code)

### Option A — Copy files (easiest)
1. Open your project folder in **VS Code**.
2. Copy the included `.codex/` folder into the **root of your repo**:
   - Your repo should look like: `my-repo/.codex/agents.md`, `my-repo/.codex/brief.md`, etc.
3. Commit to git (recommended):
   - `git add .codex && git commit -m "Add Codex Memory Kit"`

### Option B — Create from scratch (manual)
Create these folders:
- `.codex/memory`
- `.codex/meta`
- `.codex/state`

Then paste in the file contents from this kit.

---

## Use

### 1) Fill in the Brief
Edit: `.codex/brief.md`

Be honest and specific. This is the seed that prevents Codex from “helpfully” inventing your product.

### 2) In Codex, type: `start`
On the first run, Codex should:
- scaffold missing files
- initialize memory from `brief.md`
- catalog skills into `memory/capabilities.md`
- write a boot entry to `state/history.md`

### 3) Work normally
On each task:
- Codex reads `.codex/brief.md` + memory
- Codex invokes skills automatically when triggers match
- Codex updates `state/active-task.md` and appends to `state/history.md`
- Memory updates happen only if mutation guards allow it

---

## How skill triggers work

Rules live in:
- `.codex/meta/skill-trigger-spec.md`

Codex can invoke skills without you asking, when:
- the task matches trigger keywords
- the output type matches (docs/tests/UI/themes/canvas)
- the category mapping applies

Codex will log skill usage in `state/active-task.md`.

---

## How memory stays truthful

Rules live in:
- `.codex/meta/mutation-guards.md`

Key principle:
> If it changes, record the change and why — don’t rewrite history.

- `decisions.md` is append-only
- `history.md` is append-only
- controlled-edit files require evidence + a change log

---

## Selling / Lead Magnet Positioning (simple)

Name ideas:
- “Codex Memory Kit”
- “Local Memory Bank for Codex”
- “Repo-Brain: Durable Context for AI Coding”

Pitch:
- “Stop re-explaining your repo every session.”
- “Make Codex consistent and auditable.”
- “Local files only — no cloud memory.”

Bundle suggestions:
- Include an example `brief.md` for a sample project
- Add a short Loom demo
- Add a one-page “Why this works” PDF

---

## License
Pick your license (MIT, Apache-2.0, or proprietary). This kit ships unlicensed by default.

END
