# Skill Trigger Spec
> File: `.codex/meta/skill-trigger-spec.md`

This file defines deterministic heuristics for choosing installed skills.

Skills live globally at: `~/.codex/skills/` (example: `/Users/user/.codex/skills`)
(Repo-local `.codex/skills/` may also exist.)

## Installed Skills (Known)
- algorithmic-art
- canvas-design
- doc-coauthoring
- frontend-design
- skill-creator
- theme-factory
- webapp-testing

---

## General Matching Rules
A skill is a match if:
1) the user request includes a trigger keyword/phrase, OR
2) the user request implies the skill’s output type, OR
3) the task category maps to the skill.

When multiple skills match:
1) choose the most specific trigger match
2) else choose the output-type match
3) else choose the lower-risk skill first (analysis/design before codegen)

---

## Skill-Specific Triggers

### algorithmic-art
Use when generating procedural/generative art, algorithmic visuals, math-driven patterns.
Trigger keywords: generative, procedural, fractal, noise, shader, algorithmic art, pattern generator, p5.js, processing, L-systems, parametric.

Often pairs with: canvas-design, theme-factory.

### canvas-design
Use when building HTML5 canvas experiences: drawing, animation loops, particles, simple games, interactive visuals.
Trigger keywords: canvas, draw, render loop, animation, particles, game, sketch, 2D renderer, requestAnimationFrame.

Often pairs with: algorithmic-art, webapp-testing, frontend-design.

### doc-coauthoring
Use when writing or restructuring documentation: PRD, spec, README, onboarding, changelog, architecture docs.
Trigger keywords: docs, documentation, README, guide, spec, PRD, RFC, architecture doc, onboarding, runbook, SOP.

### frontend-design
Use when designing or implementing UI: components, layouts, responsive design, CSS/Tailwind, React/Next, forms.
Trigger keywords: UI, frontend, component, layout, responsive, Tailwind, CSS, React, Next.js, shadcn, design system.

Often pairs with: theme-factory, webapp-testing, doc-coauthoring.

### theme-factory
Use when creating themes: color palettes, typography rules, design tokens, branding variants.
Trigger keywords: theme, palette, colors, tokens, branding, typography, styles, design tokens, dark mode, theming.

Often pairs with: frontend-design, canvas-design.

### webapp-testing
Use when generating tests or QA strategy: unit tests, integration, e2e, Playwright/Cypress, test plans.
Trigger keywords: test, testing, QA, Playwright, Cypress, Jest, Vitest, coverage, regression, flaky test.

### skill-creator
Use when you need a new skill, modify an existing skill, or formalize a repeatable workflow as a skill.
Trigger keywords: create a skill, new skill, skill pack, automate this, tool spec, capability, reusable workflow.

---

## Non-hallucination Rule
- Do not claim a skill exists unless it is listed in `capabilities.md` or found in the skills folders.
- If a trigger matches but the skill is missing, proceed without it and note the gap in `state/history.md`.

END
