# Codex Memory Kit (Local, Auditable “Memory” for Codex)

This kit gives Codex a repo-local memory system under `.codex/`:
- A project brief (`.codex/brief.md`) that acts like the source of truth
- A control plane (`.codex/agents.md`) that defines boot + rules
- A structured memory bank (`.codex/memory/`)
- Deterministic skill triggers (so Codex can use skills proactively)
- Mutation guards so history can’t be rewritten “helpfully”
- A visible UI indicator: `[Codex Memory: Active]`

Everything is plain Markdown. Everything can be committed to git.

---

## What you get

Inside `.codex/`:
- `agents.md` — boot rules + task lifecycle + UI status indicator rule
- `brief.md` — project description and plan seed
- `memory/` — durable context (architecture, constraints, decisions, patterns)
- `meta/` — mutation guards + trigger heuristics
- `state/` — active task + append-only history

Codex skills live globally at:
- `~/.codex/skills/` (macOS; example: `/Users/user/.codex/skills`)

This kit does NOT copy skill internals into memory. It only catalogs what skills exist and when to use them.

---

## Install (macOS, VS Code)

### Option A — Copy files (easiest)
1. Open your project folder in VS Code.
2. Copy the included `.codex/` folder into the root of your repo.
3. (Recommended) Commit to git:
   ```bash
   git add .codex && git commit -m "Add Codex Memory Kit"
   ```

---

## UI status indicator

Codex is instructed to prefix every response with one of:

- `[Codex Memory: Bootstrapping]` (first-run after you type `start`)
- `[Codex Memory: Active]` (memory loaded and in use)
- `[Codex Memory: Inactive]` (memory not initialized)

This is deliberate UX: it makes it obvious when Codex is actually using the `.codex/` memory bank.

---

## Use

### 1) Fill in the Brief
Edit `.codex/brief.md`. Be honest and specific.

### 2) In Codex, type: `start`
On the first run, Codex should:
- scaffold missing files
- initialize memory from `brief.md`
- catalog skills into `memory/capabilities.md`
- enforce mutation guards
- begin logging tasks in `state/history.md`

### 3) Work normally
On each task:
- Codex reads `.codex/brief.md` + memory
- Codex invokes skills automatically when triggers match
- Codex updates `state/active-task.md` and appends to `state/history.md`
- Memory updates happen only if mutation guards allow it

---

## Selling / Lead Magnet Positioning (simple)

Name ideas:
- Codex Memory Kit
- Local Memory Bank for Codex
- Repo-Brain: Durable Context for AI Coding

Pitch:
- “Stop re-explaining your repo every session.”
- “Make Codex consistent and auditable.”
- “Local files only — no cloud memory.”

Bundle suggestions:
- Include an example `brief.md` for a sample project
- Add a short demo video
- Add a one-page “Why this works” PDF

---

## License
Pick your license (MIT, Apache-2.0, or proprietary). This kit ships unlicensed by default.

END
